 
; simplestats, timer, startup manager, menus

(defun means ()
"Args: none
Reports the means of the active numeric variables."
  (send $ :means))

(defun medians ()
"Args: none
Reports the medians of the active numeric variables."
  (send $ :medians))

(defun standard-deviations  ()
"Args: none
Reports the standard-deviations  of the active numeric variables."
  (send $ :standard-deviations ))

(defun variances ()
"Args: none
Reports the variances of the active numeric variables."
  (send $ :variances))

(defun minimums ()
"Args: none
Reports the minimums of the active numeric variables."
  (send $ :minimums  ))

(defun maximums ()
"Args: none
Reports the maximums of the active numeric variables."
  (send $ :maximums  ))

(defun kurtoses ()
"Args: none
Reports the kurtoses of the active numeric variables."
  (send $ :kurtoses))

(defun skewnesses ()
"Args: none
Reports the kurtoses of the active numeric variables."
  (send $ :skewnesses ))


(setf *hide-datasheet* t)
(setf *hide-desktop* *hide-vista*)
(setf *start-manager* nil)
(setf *startup-manager* nil)
(setf *vue-manager* nil)
(setf *startup-code* nil)
(setf *dde-data* nil)
(setf *vdf-data* nil)
(setf *vaf-progn* nil)
(setf *vista-startup-error* nil)

(setf *timer* (send graph-proto :new 2 :show nil))

(defmeth *timer* :action (&optional (afunc nil set))
"Message args: (&optional afunc)
 Sets or retrieves the action function."
  (unless (send self :has-slot 'action) 
          (send self :add-slot 'action #'default-create-vista-process))
  (if set (setf (slot-value 'action ) afunc ))
  (slot-value 'action))

(defmeth *timer* :do-idle () 
  (send self :do-action))

(defmeth *timer* :do-action () 
  (funcall (send self :action)))

(defun activate (window)
  (send window :active-window))


;=============================


(defun show-all-options  (&optional (logical nil used?))
"Arg: (logical nil used?)
This function is obsolete. Shows or hides all optional items in the OPTIONS menu. Toggles state, unless logical is specified."
  (unless used?
          (if (boundp '*show-all-options*)
              (setf *show-all-options (not *show-all-options))
              (setf *show-all-options t))
          (setf logical *show-all-options))
  (setf *change-workmap*  logical)
  (setf *change-toolbar*  logical)
  (setf *change-profiles* logical)
  (setf *change-excess*   logical)
  (setf *enable-screen-saver-feature* logical)
  (install-command-menu))



  (defun menus (&optional (arg t used?))
    "Installs or removes menus in desktop container. For first-time installation do not use the argument. After that, use T or NIL to install or remove menus from desktop menubar. If menus installed when T is used, automatically reinstalls the menus."
    (when arg
          (enable-container *desktop-container*)
          (send *desktop-window-menu* :install)            
          (send *vista-file-menu* :install)
          (send *vista-edit-menu* :install)
          (send *data-menu*       :install)
          (send *plots-menu*      :install)
          (send *views-menu*      :install)
          (send *trans-menu*      :install)
          (send *tools-menu*      :install)
          (send *model-menu*      :install)            
          (send *command-menu*    :install)
          (send *command-menu*    :update-items)
          (send *help-menu*       :install)
          (when (and *pro-version* *devel-mode*)
                (send *devel-menu*   :install))
          (send *desktop-desktop-menu* :install)
          )
    (when (not arg)
          (send *desktop-window-menu* :remove)
          (send *vista-file-menu* :remove)
          (send *vista-edit-menu* :remove)
          (send *data-menu*    :remove)
          (send *plots-menu*   :remove)
          (send *views-menu*   :remove)
          (send *trans-menu*   :remove)
          (send *tools-menu*   :remove)
          (send *model-menu*   :remove)
          (send *command-menu* :remove)
          (send *help-menu*    :remove)
          (when (and *pro-version* *devel-mode*)
                (send *devel-menu*   :remove))
          (send *desktop-desktop-menu* :remove)
          )
    arg)
  
;#+containers(when *ni* (disable-container))

(defun read-devel-files ()
  (let ((file-list (directory (strcat *devel-dir-name* "*.lsp"))))
    (when file-list
          (mapcar #'(lambda (file) 
                      (gc) 
                      (load file))
                  (sort-data file-list))
          )))



(defun print-initial-variables ()
  (format nil "; *initial-install*: ~a~%"*initial-install*)
  (format nil "; *pro-version*:     ~d~%"*pro-version*)
  (format nil "; prefs-dir?:        ~a~%"prefs-dir?)
  (format nil "; user-dir?:         ~a~%"user-dir?)
  (format nil "; ini-exists?:       ~a~%"ini-exists?)
  (format nil "; *run-number*:      ~d~%"*run-number*)
  (format nil "; *show-web-docs*    ~d~%"*show-web-docs*)
  (when *vista*
        (format nil "; show-first-help ~d~%" (send *vista* :show-first-help))
        (format nil "; show-welcome    ~d~%" (send *vista* :show-welcome)))
  )


(defun set-user-privileges (user-type)
  ;(set-vista-pro-version)
  (let ((ut (cond 
              ((equal *user-type* "Help") "Help")
              (user-type user-type)
              (*pro-version* "Developer")
              (*user-type* *user-type*))))
;(print (list "IN SETUSERPRIVILEGES" ut))
  (cond
    ((equal ut "Help")
     (user-profile-help) 
     (make-win-user-profile))
    ((equal ut "Developer")
     (setf *show-devel-menu* t)
     (setf *update-pref-files* t)
     (setf *change-excess* t)
     (setf *change-fonts* t)      
     (setf *change-directories* t)
     (setf *change-profiles* t)
     (setf *configure* t)
     (setf *change-toolbar* t)
     (setf *change-workmap* t)
     (setf *enable-screen-saver-feature* t)
     (set-vista-pro-version)
     )
    ((equal ut "User")  
     (setf *show-devel-menu* nil)   ;cant see developers menu
     (setf *update-pref-files* t)   ;write anywhere
     (setf *change-excess* t)       ;access to excess
     (setf *change-fonts* nil)      ;access to fonts 
     (setf *change-directories* nil);no access to directory menus
     (setf *change-profiles* t)     ;access to startup configuration
     (setf *configure* nil)         ;access to menu configuration
     (setf *change-toolbar* t)      ;access to Toolbar Menu Item
     (setf *change-workmap* t)      ;access to WorkMap Menu Items
     (setf *enable-screen-saver-feature* t);access to screen saver
     (set-vista-pro-version nil))  
    (t
     (setf *show-devel-menu* nil)
     (setf *update-pref-files* nil) ;write nowhere
     (setf *change-excess* nil)     ;no access to excess
     (setf *change-fonts* nil)      ;no access to fonts 
     (setf *change-directories* nil);no access to directory menus
     (setf *change-profiles* nil)   ;no access to startup configuration
     (setf *configure* nil)         ;no access to menu configuration
     (setf *change-toolbar* nil)    ;no access to Toolbar Menu Item
     (setf *change-workmap* t)      ;access to WorkMap Menu Items
     (setf *enable-screen-saver-feature* nil);no access to screen saver
     (set-vista-pro-version nil))) 
    (setf *author* nil)
    ))

(defun set-vista-pro-version (&optional (nilt nil used?))
"Arg: (&optional (NILT NIL USED?))
Sets *pro-version* to NILT (T or NIL) if NILT is used, otherwise sets *pro-version* to (and (equal *user-type* User) (equal *installer-type* User) (not (not (probe-base-file))))"
  (setf *pro-version*
        (cond
          (used? nilt)
          (t (and (equal *user-type* "User")
                  (equal *installer-type* "User")
                  (not (not (probe-base-file)))))))
   *pro-version*)
  

(defun doco-defaults ()
  (default-colors)
  (apply #'send *desktop-container* :size *doco-screen-size*)
  (apply #'send *desktop-container* :location (floor (/ (- (effective-screen-size) (send *desktop-container* :size)) 2)))
  (set-devel-mode nil)
  (send *workmap* :has-v-scroll nil)
  (send *workmap* :has-H-scroll nil)
  )

(defun mini-seven-values ()
  (combine *doco-screen-size* 
           (floor (/ (- (effective-screen-size) *doco-screen-size*) 2))
           1
           (effective-screen-size)))

(defun make-mac-user-profile ()
  (setf *macos8* (two-button-dialog "Using MacOS 8?" :first-button "Yes" :second-button "No"))
  (setf *update-pref-files* t) 
  (setf *change-menus* t)
  (setf *change-directories* t)
  (setf *change-profiles* t)
  (setf *configure* t)
  (setf *change-workmap* t)
  (setf *enable-screen-saver-feature* t)
  (setf *author* nil)
  (setf *show-devel-menu* nil)
  (setf *macos8* nil)
  (write-prefload-file))

(defun help-to-display-window (s)
  (display-window s :color 'light-red :fit t))


(defun configure-excel (&optional admin)
  (let* ((text (send text-item-proto :new 
                              (format nil "Configure Excel for ViSta~%NOTE: Excel 2000 does not work with ViSta")))
         (choice (send choice-item-proto  :new 
                       (list "Do Not Install ViSta menu in Excel"
                             "Install/Uninstall Persistant ViSta menu (Local EXCEL only)"
                             "Single-run ViSta menu (Local or Server-based EXCEL)")))
         (cancel  (send modal-button-proto :new "Cancel"))
         (back    (send modal-button-proto :new "Back" :action #'(lambda () "Back")))
         (help    (send modal-button-proto :new "Help" :action #'(lambda () "Help")))
         (next-ok (send modal-button-proto :new (if admin "Next" "OK")
                      :action #'(lambda () 
                                  (send choice :value) )))
         (items (list text choice 
                      (if admin 
                          (list (list back next-ok help cancel))
                          (list next-ok help cancel))))
         (dialog (send modal-dialog-proto :new items
                       :title "Configure Excel/ViSta"
                       :default-button next-ok))
         (result (send dialog :modal-dialog)))
    (defmeth choice :do-action ()
        (if (= (send self :value) 1)  (system "ExcelViSta.exe")))
    (cond 
      ((not result))
      ((equal result "Help") 
       (configure-excel-help admin))
      ((equal result "Back") 
       (admin-configure-menus))
      ((= result 2) ;single-run
       (setf *local-excel?* t)
       (setf *no-local-excel?* nil)
       )
      ((= result 1) ;persistent
       (setf *local-excel?* nil)
       (setf *no-local-excel?* t)
       (let ((nowdir (get-working-directory)))
         (set-working-directory (strcat *default-path* "startup\\"))
         (system "ExcelViSta.exe")
         ;(install-excel-vista-menu-dialog )          
         (set-working-directory nowdir)
         )))
    (send dialog :size 
          (first (floor (* 4/5 (send dialog :size))))
          (second (send dialog :size)))
    (send dialog :location 
          (floor (* 1/2 (first (- (effective-screen-size) (send dialog :size))))) 40)
    result))

(defun configure-excel-help (admin)
  (let* ((title (send text-item-proto :new (format nil "HELP: CONFIGURE EXCEL")))
         (text1 (send text-item-proto :new (format nil 
"Microsoft Excel can be configured to have a special ViSta menu that~%lets you use ViSta to see your Excel data.")))
         (text2 (send text-item-proto :new 
(format nil "WHEN EXCEL IS ON YOUR LOCAL MACHINE~%When Excel is locally installed there are two installation methods.~%1: PERMANENT INSTALLATION: Install the menu permanently so you can~%always see your data with ViSta. You can remove the menu when you wish.~%2: SINGLE RUN INSTALLATION: Run Excel from a special Excel/ViSta shortcut.~%The shortcut installs the ViSta menu only for that run of Excel.")))
         (text3 (send text-item-proto :new 
(format nil "EXCEL IS ON A SERVER~%SINGLE RUN INSTALLATION: When Excel is on a server you can install the~%ViSta menu in Excel only by using the special Excel/ViSta shortcut.
")))
         (ok  (send modal-button-proto :new "OK"))
         (dialog (send modal-dialog-proto :new (list title text1 text2  text3 ok))))
    (send dialog :modal-dialog)
    (configure-excel admin)))


(defun configure-local-access ()
  (let ((nowdir (get-working-directory)))
    (set-working-directory (strcat *default-path* "startup\\"))
    (system "AccessViSta.exe")
    (set-working-directory nowdir)))

(defun install-excel-vista-menu-dialog ()
  (let* ((text (send text-item-proto :new "Install ViSta Menu in Excel"))
         (text2 (send text-item-proto :new (format nil "Make your choice in Dialog above,~%Then click OK below")))
         (ok  (send modal-button-proto :new "OK"))
         (dialog (send modal-dialog-proto :new (list text text2 ok))))
    (apply #'send dialog :frame-location (+ (send dialog :frame-location) (list -20 (second (send dialog :size)))))
    (system "ExcelViSta.exe")
    (send dialog :modal-dialog)))

(defun md () 
  (hidemainwindow)
  (maxmainwindow)
  (set-working-directory *default-path*)
  (setf *load-verbose* t)
  (setf *file-verbose* t)
  )

(defconstant *colors* '(WHITE GREY BROWN BLACK PINK RED DARK-RED GREEN DARK-GREEN LIGHT-BLUE BLUE CYAN YELLOW ORANGE MAGENTA VIOLET))
